<x-app-layout>
    <x-slot name="header">
        @lang('app.dashboard')
    </x-slot>

    <!-- Row -->
    <div class="row">
        @if (!user()->address)
        <div class="col-lg-12 mb-4">
            <div class="alert alert-warning border-0 shadow-sm rounded-3">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-exclamation-circle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h4 class="alert-heading mb-1">Profile Incomplete</h4>
                        <p class="mb-2 text-muted">To enhance your booking experience, please take a moment to complete
                            your profile information.</p>
                        <a href="{{ route('profile.address') }}" class="btn btn-warning px-4">
                            <i class="fas fa-user-edit me-2"></i>Update Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <div class="col-lg-4 col-md-6">
            <x-widget type="booking" color="#4ecc48" />
        </div>
        <div class="col-lg-4 col-md-6">
            <x-widget type="pending-booking" color="#ffcc00" />
        </div>
        <div class="col-lg-4 col-md-6">
            <x-widget type="approved-booking" color="#05c3fb" />
        </div>
        <div class="col-lg-4 col-md-6">
            <x-widget type="completed-booking" color="#5965f9" />
        </div>
        <div class="col-lg-4 col-md-6">
            <x-widget type="rejected-booking" color="#e82646" />
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Latest Bookings</h3>
                </div>
                <div class="card-body">
                    <x-table.booking :bookings="$bookings" route="admin.booking.show" />
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</x-app-layout>
